/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.quantumdatasdk;

import com.quantumdata.quantumdatasdk.ChooseFileDialog;
import com.quantumdata.quantumdatasdk.ConfigData;
import com.quantumdata.quantumdatasdk.ExtensionFilter;
import com.quantumdata.quantumdatasdk.MainScreen;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public class ChangeFileEditorDialog
extends JDialog
implements ActionListener {
    private static final long serialVersionUID = 923430910569838861L;
    private static final String sConfirmChange = "CONFIRM_CHANGE";
    private static final String sCancelChange = "CANCEL_CHANGE";
    private static String[] editorName = new String[]{"SDK Default Editor", "NotePad", null, null, null, null, null, null, null, "Other..."};
    private static String[] editorExecution = new String[]{"SDK Default Editor", "NotePad", null, null, null, null, null, null, null, "Other..."};
    private static int availableEditorNum = 2;
    private JComboBox aChooseEditor;
    private static String userInput;
    private static boolean editorBeingChanged;

    public ChangeFileEditorDialog(ActionListener actionListener) {
        this.InitScreen(actionListener);
    }

    protected void finalize() {
        this.aChooseEditor = null;
        for (int i = 0; i < editorName.length; ++i) {
            if (editorName[i].length() == 0) continue;
            ChangeFileEditorDialog.editorName[i] = null;
        }
    }

    public void InitScreen(ActionListener actionListener) {
        this.setModal(true);
        this.setTitle("Change File Editor");
        JLabel jLabel = MainScreen.getLabel("Choose the new Script File Editor: ", 12, 1, false);
        this.aChooseEditor = new JComboBox();
        this.aChooseEditor.setToolTipText("Select The File Editor.");
        this.aChooseEditor.setEditable(false);
        this.aChooseEditor.addItem(ConfigData.sFileEditor);
        for (int i = 0; i < ConfigData.sMaxEditorNum; ++i) {
            if (editorName[i] == null || editorName[i].equalsIgnoreCase(ConfigData.sFileEditor)) continue;
            this.aChooseEditor.addItem(editorName[i]);
        }
        jLabel.setLabelFor(this.aChooseEditor);
        this.aChooseEditor.addActionListener(this);
        JButton jButton = new JButton("Ok");
        jButton.setVerticalTextPosition(0);
        jButton.setHorizontalTextPosition(10);
        jButton.setMnemonic('O');
        jButton.setActionCommand(sConfirmChange);
        jButton.addActionListener(this);
        jButton.setDefaultCapable(true);
        JButton jButton2 = new JButton("Cancel");
        jButton2.setVerticalTextPosition(0);
        jButton2.setHorizontalTextPosition(10);
        jButton2.setMnemonic('C');
        jButton2.setActionCommand(sCancelChange);
        jButton2.addActionListener(this);
        JPanel jPanel = new JPanel();
        jPanel.add(jButton);
        jPanel.add(jButton2);
        int n = 0;
        GridBagLayout gridBagLayout = new GridBagLayout();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.setLayout(gridBagLayout);
        gridBagConstraints = MainScreen.createGridBagConstraints(1, 0, n, 0, 22);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        gridBagConstraints = MainScreen.createGridBagConstraints(1, 1, n++, 0, 21);
        gridBagLayout.setConstraints(this.aChooseEditor, gridBagConstraints);
        this.add(this.aChooseEditor);
        gridBagConstraints = MainScreen.createGridBagConstraints(2, 0, n++, 0, 10);
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.aChooseEditor)) {
            String string = (String)this.aChooseEditor.getSelectedItem();
            if (string.equals("Other...")) {
                editorBeingChanged = this.selectFileEditor();
            } else {
                userInput = string;
                editorBeingChanged = true;
            }
        } else if (actionEvent.getActionCommand().equalsIgnoreCase(sConfirmChange)) {
            if (editorBeingChanged) {
                boolean bl = false;
                for (int i = 0; i < ConfigData.sMaxEditorNum; ++i) {
                    if (editorExecution[i] != userInput) continue;
                    ConfigData.sFileEditor = editorExecution[i];
                    bl = true;
                }
                if (!bl) {
                    ChangeFileEditorDialog.editorExecution[ChangeFileEditorDialog.availableEditorNum] = userInput;
                    ChangeFileEditorDialog.editorName[ChangeFileEditorDialog.availableEditorNum] = ConfigData.getName(userInput);
                    ConfigData.sFileEditor = editorName[availableEditorNum];
                    if (++availableEditorNum >= ConfigData.sMaxEditorNum) {
                        JOptionPane.showMessageDialog(null, "You are not allowed to add more than " + ConfigData.sMaxEditorNum + "editors", "Too much editors", 0);
                    }
                }
                editorBeingChanged = false;
            }
            ConfigData.StoreConfig();
            this.setVisible(false);
        }
        if (actionEvent.getActionCommand().equalsIgnoreCase(sCancelChange)) {
            this.setVisible(false);
            editorBeingChanged = false;
        }
    }

    private boolean selectFileEditor() {
        ChooseFileDialog chooseFileDialog = new ChooseFileDialog("Choose File Editor", "Choose", "Choose File Editor", 2, new ExtensionFilter(".exe", "File Editors (*.exe)"), this, new File("c:\\*", ""));
        File file = chooseFileDialog.getFile();
        if (file != null) {
            userInput = file.getAbsolutePath();
            return true;
        }
        return false;
    }

    public boolean validateData() {
        boolean bl = true;
        return bl;
    }

    static {
        editorBeingChanged = false;
    }
}

